
(define (domain sokoban)
  (:requirements :typing )
  (:types thing location direction)
  (:predicates (move-dir ?v0 - location ?v1 - location ?v2 - direction)
	(is-nongoal ?v0 - location)
	(clear ?v0 - location)
	(is-stone ?v0 - thing)
	(at ?v0 - thing ?v1 - location)
	(is-player ?v0 - thing)
	(at-goal ?v0 - thing)
	(move ?v0 - direction)
	(is-goal ?v0 - location)
  )

  ; (:actions move)

  

	(:action move
		:parameters (?from - location ?to - location ?dir - direction)
		:precondition (and (move ?dir)
			(is-player player-01)
			(at player-01 ?from)
			(clear ?to)
			(move-dir ?from ?to ?dir))
		:effect (and
			(not (at player-01 ?from))
			(not (clear ?to))
			(at player-01 ?to)
			(clear ?from))
	)
	

	(:action push-to-goal
		:parameters (?box - thing ?ppos - location ?from - location ?to - location ?dir - direction)
		:precondition (and (move ?dir)
			(is-player player-01)
			(is-stone ?box)
			(at player-01 ?ppos)
			(at ?box ?from)
			(clear ?to)
			(move-dir ?ppos ?from ?dir)
			(move-dir ?from ?to ?dir)
			(is-goal ?to))
		:effect (and
			(not (at player-01 ?ppos))
			(not (at ?box ?from))
			(not (clear ?to))
			(at player-01 ?from)
			(at ?box ?to)
			(clear ?ppos)
			(at-goal ?box))
	)
	

	(:action push-to-nongoal
		:parameters (?box - thing ?ppos - location ?from - location ?to - location ?dir - direction)
		:precondition (and (move ?dir)
			(is-player player-01)
			(is-stone ?box)
			(at player-01 ?ppos)
			(at ?box ?from)
			(clear ?to)
			(move-dir ?ppos ?from ?dir)
			(move-dir ?from ?to ?dir)
			(is-nongoal ?to))
		:effect (and
			(not (at player-01 ?ppos))
			(not (at ?box ?from))
			(not (clear ?to))
			(at player-01 ?from)
			(at ?box ?to)
			(clear ?ppos)
			(not (at-goal ?box)))
	)

)
        